package gov.va.med.mhv.usermgmt.common.dto;

import java.io.Serializable;
import java.util.Date;

public class SessionTO implements Serializable {
	private static final long serialVersionUID = 5415762629326673596L;

	private Long userId;
	
	private Date expirationDate;
	
	public SessionTO(){
	}
	
	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Date getExpirationDate() {
		return expirationDate;
	}

	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}
	
	public String getToken(){
		return getTokenEncoded(this);
	}
	
	private static String getTokenEncoded(SessionTO session) {
		return org.apache.cxf.common.util.Base64Utility.encode( ("|"+String.valueOf(session.getUserId())+"|"+String.valueOf(session.getExpirationDate().getTime())+"|").getBytes(),true);
	}
	
}
